$(document).ready(function() {
	//Tabs...
	$(".tab_content").not(':first').fadeOut(); //Hide all content
	$("ul.tabs li:first").addClass("active").show(); //Activate first tab

	//On Click Event
	$("ul.tabs li").click(function() {
		$("ul.tabs li").removeClass("active"); //Remove any "active" class
		$(this).addClass("active"); //Add "active" class to selected tab
		$(".tab_content").hide(); //Hide all tab content

		var activeTab = $(this).index();
		$('.tab_content').eq(activeTab).fadeIn(); //Fade in the active ID content
		return false;
	});

	//Accordion
	$('.acc_container').hide(); //Hide/close all containers
	$('.acc_trigger:first').addClass('active').next().show(); //Add "active" class to first trigger, then show/open the immediate next container
	
	//On Click
	$('.acc_trigger').click(function(){
		if( $(this).next().is(':hidden') ) { //If immediate next container is closed...
			$('.acc_trigger').removeClass('active').next().slideUp(); //Remove all "active" state and slide up the immediate next container
			$(this).toggleClass('active').next().slideDown(); //Add "active" state to clicked trigger and slide down the immediate next container
		}
		return false; //Prevent the browser jump to the link anchor
	});

	$("tr:even").addClass("even");

	// Closing Divs - used on Notification Boxes
	$(".canhide").click(function() {
		$(this).fadeOut(700);
	});
	
	$("a[rel*=tipsy]").tipsy ({ gravity: 'n', fade: 'true' });
	
	// Check all the checkboxes when the head one is selected:
	$('.checkall').click(
		function(){
			$(this).parent().parent().parent().parent().find("input[type='checkbox']").attr('checked', $(this).is(':checked'));   
		}
	);
	
	$('input[type="submit"]').click(function(){
		var error = 0;
		
		$(this).parent('form').find('.required').each(function(){
			if ($(this).val() == '') {
				$(this).addClass('validation_error');
				error++;
			}
		});
		
		if (error) {
			return false;
		}
	});
	
	$('ul.listing span.arrow').find('a').click(function(){
		var current = $(this);
		var par = current.parent().parent().children('p');
		
		current.parent().parent().parent().children('li').find('p').each(function(){
			$(this).not(par).slideUp(400);
			$(this).not(par).parent().children('span.arrow').children('a').find('img').attr('src', 'assets/images/arrow-down.png');
		});
		
		if (par.is(':visible')) {
			current.find('img').attr('src', 'assets/images/arrow-down.png');
			par.slideUp(400);
		} else {
			current.find('img').attr('src', 'assets/images/arrow-up.png');
			par.slideDown(400);
		}
		
		return false;
	});
	
	$('form .required').click(function(){
		$(this).removeClass('validation_error');
	});
	
	$('form .required').focus(function(){
		$(this).removeClass('validation_error');
	})
	
	$('a.delete').click(function(){
		var delete_button = $(this);
		
		$('#dialog-confirm').dialog({
			resizable: false,
			height:170,
			modal: true,
			buttons: {
				'Po, fshije!': function() {
					$(this).dialog('close');
					document.location.href = delete_button.attr('href');
				},
				'Jo': function() {
					$(this).dialog('close');
				}
			}
		});
		
		return false;
	});
	
	$('div.success').click(function(){
		rel = $(this).attr('rel');
		
		if (rel != undefined) {
			document.location.href = rel;
		}
	});
	
	$('input.focus, textarea.focus').focus();
	
	$('ul.menu-sortable').sortable({
		handle: 'span.handle',
		distance: 15,
		axis: 'y',
		update: function (event, ui) {
			var order = $('ul.menu-sortable').sortable('serialize', {key: 'order[]'});
			$.get('ajax.php?' + order + '&action=updateMenuSort');
		}
	});
	
	$('ul.submenu-sortable').sortable({
		handle: 'span.handle',
		distance: 15,
		axis: 'y',
		update: function (event, ui) {
			var order = $(this).sortable('serialize', {key: 'order[]'});
			$.get('ajax.php?' + order + '&action=updateSubmenuSort');
		}
	});
	
	$('input.date').datepicker({
		dateFormat: 'd MM yy',
		showButtonPanel: true,
		firstDay: 1,
		changeMonth: true,
		changeYear: true,
		showAnim: 'slide',
		showOptions: {direction: 'up' },
		currentText: 'Sot',
		closeText: 'X',
		dayNames: ['E Diele', 'E Hene', 'E Marte', 'E Merkure', 'E Enjte', 'E Premte', 'E Shtune'],
		dayNamesMin: ['Di', 'He', 'Ma', 'Me', 'En', 'Pr', 'Sh'],
		dayNamesShort: ['Die', 'Hen', 'Mar', 'Mer', 'Enj', 'Pre', 'Sht'],
		monthNames: ['Janar','Shkurt','Mars','Prill','Maj','Qershor','Korrik','Gusht','Shtator','Tetor','Nentor','Dhjetor'],
		monthNamesShort: ['Jan','Shk','Mar','Pri','Maj','Qer','Kor','Gus','Sht','Tet','Nen','Dhj']
	});
	
	function getURLParameter(name) {
	    return decodeURI(
	        (RegExp(name + '=' + '(.+?)(&|$)').exec(location.search)||[,null])[1]
	    );
	}
	
	var product_id = getURLParameter('id');
	
});

tinyMCE.init({
        // General options
        mode : "specific_textareas",
        editor_selector : "tinymce",
		theme : "advanced",
		skin : "cirkuit",
		language : "sq",
		relative_urls : false,
		remove_script_host: false,
		convert_urls : false,
		plugins : "pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template",
	
		// Theme options
		theme_advanced_buttons1 : "bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,formatselect,fontselect,fontsizeselect,|,pastetext,pasteword,|,undo,redo,|,nonbreaking,pagebreak,|,charmap,media,|,print,|,fullscreen",
		theme_advanced_buttons2 : "bullist,numlist,|,outdent,indent,blockquote,|,link,unlink,image,code,|,forecolor,backcolor,|,tablecontrols,|,hr,visualaid,|,sub,sup,|,styleprops",
		theme_advanced_buttons3 : "",
		theme_advanced_toolbar_location : "top",
		theme_advanced_toolbar_align : "left",
		theme_advanced_statusbar_location : "bottom",
		theme_advanced_resizing : false,
	
		// Drop lists for link/image/media/template dialogs
		template_external_list_url : "lists/template_list.js",
		external_link_list_url : "lists/link_list.js",
		external_image_list_url : "lists/image_list.js",
		media_external_list_url : "lists/media_list.js",
		
		//CKFinder initialization
		file_browser_callback: 'openKCFinder'
});

//CKFinder setup function
function openKCFinder(field_name, url, type, win) {
	tinyMCE.activeEditor.windowManager.open({
		file: 'assets/js/kcfinder/browse.php?opener=tinymce&lng=sq',
		title: 'Ngarkuesi i Skedareve',
		width: 700,
		height: 500,
		resizable: "yes",
		inline: true,
		close_previous: "no",
		popup_css: false
	}, {
		window: win,
		input: field_name
	});
	return false;
}

Shadowbox.init({
    handleOversize: "resize",
	viewportPadding: 100
});