<?php

class SG_Post_Module extends SG_Module {

	const moduleName = 'Post';

	protected static $instance;
	protected static $_vars = NULL;
	protected static $_params = array();

	protected static $_fields = array(
		'show_thumbnail' => array(
			'name' => 'Show Hide Thumbnail',
			'type' => 'select',
			'options' => array(
				'yes' => 'Show',
				'no' => 'Hide',
			),
			'default' => 'yes',
			'show' => self::SHOW_ALL,
			'help' => 'Show or hide post thumbnail',
		),
		'show_comments' => array(
			'name' => 'Show Hide Comments',
			'type' => 'select',
			'options' => array(
				'yes' => 'Show',
				'no' => 'Hide',
			),
			'default' => 'yes',
			'show' => self::SHOW_ALL,
			'help' => 'Allow or disallow comments',
		),
		'parent' => array(
			'name' => 'Parent',
			'type' => 'select',
			'options' => array(),
			'default' => '#',
			'show' => self::SHOW_ALL,
			'help' => 'Select parent blog page to be displayed in Breadcrumbs',
		),
	);

	protected static $_description = NULL;

	private function __construct() {}
	private function __clone() {}

	public static function getInstance()
	{
		if (is_null(self::$instance)) {
			self::$instance = new SG_Post_Module;
		}
		return self::$instance;
	}

	public function inited()
	{
		return !is_null(self::$_vars);
	}

	public function initVars($uniq, $params, $defaults, $global, $post_id)
	{
		self::$_vars = self::_initVars(self::moduleName, $uniq, self::$_params, self::$_fields, $params, $defaults, $global, $post_id);
		return TRUE;
	}

	public function setVars($uniq, $post_data, $post_id = NULL)
	{
		return self::_setVars(self::moduleName, $uniq, self::$_fields, $post_data, $post_id);
	}

	public function resetVars($uniq, $post_id = NULL)
	{
		return self::_resetVars(self::moduleName, $uniq, $post_id);
	}

	public function getMenuItem()
	{
		return __('Content', SG_TDN);
	}

	public function getAdminContent($uniq, $params, $defaults, $global = NULL, $post_id = NULL)
	{
		$fields = self::$_fields;

		$get_posts = new WP_Query;
		$posts = $get_posts->query('post_type=page&posts_per_page=-1');
		$bpages = array('#' => __('-Last Blog Page-', SG_TDN));

		foreach ($posts as $post) {
			$post_custom = get_post_custom($post->ID);
			if (isset($post_custom['_wp_page_template'])) {
				if ($post_custom['_wp_page_template'][0] == 'pg-blog.php') {
					$bpages[$post->ID] = trim(esc_html(strip_tags(get_the_title($post))));
				}
			}
		}

		$fields['parent']['options'] = $bpages;

		return self::_getAdminContent(self::moduleName, $uniq, self::$_params, $fields, NULL, $params, $defaults, $global, $post_id);
	}

	public function showThumbnail()
	{
		return (self::$_vars['show_thumbnail'] == 'yes');
	}

	public function showComments()
	{
		return (self::$_vars['show_comments'] == 'yes');
	}

	public function showSearch()
	{
		return (self::$_vars['show_search'] == 'yes');
	}

	public function getParent()
	{
		return isset(self::$_vars['parent']) ? self::$_vars['parent'] : '#';
	}

}