jQuery(document).ready(function($){

 

 

    var custom_uploader;

 

 

    $("#settings-area").on("click", ".upload-image-feature-button", function(e) {

		

		var inputArea = $(this).prev(".upload-image-input").attr("id");

		

		

        e.preventDefault();

 

        //If the uploader object has already been created, reopen the dialog

        if (custom_uploader) {

            custom_uploader.open();

            return;

        }

 

        //Extend the wp.media object

        custom_uploader = wp.media.frames.file_frame = wp.media({

            title: 'Choose Image',

            button: {

                text: 'Choose Image'

            },

            multiple: false

        });

 

        //When a file is selected, grab the URL and set it as the text field's value

        custom_uploader.on('select', function() {

			attachment = custom_uploader.state().get('selection').first().toJSON();

			$("#settings-area .feature-container:visible input.upload-image-input").val(attachment.url);

			var currFeature = $("#settings-area .feature-container:visible").attr("id");

			currFeature = currFeature.substr(16);

			$("#smart-screen #screen-image-"+currFeature+" img").attr("src", attachment.url);

			$("#smart-screen #screen-image-"+currFeature+" img").attr("class", "on-screen-image");

			$("#smart-screen #screen-image-"+currFeature+" img").css("width", "50%");

        });

 

        //Open the uploader dialog

        custom_uploader.open();

 

    });

 

 

});