<?php
class Lang {

	private $allowed = array('al', 'en');
	private $default = 'en';

	public function setLanguage () {
		$lang = $this->default;
		
		if (isset($_GET['lang'])) {
			$lang = $_GET['lang'];
		} elseif (isset($_COOKIE['lang'])) {
			$lang = $_COOKIE['lang'];	
		}
		
		if (!in_array($lang, $this->allowed)) {
			$lang = $this->default;	
		}
		
		setcookie('lang', $lang, time() + 3600*24*30, '/');
		return $lang;
	}
	
	public function get () {
		return $this->setLanguage();
	}

	public function path ($lang) {
		$page = $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
		$page = str_replace('http://', '', $page);
		$page = 'http://'.$page;

		if (strpos($page, '/al/') !== false)
		{
			$page = str_replace('/al/', "/$lang/", $page);
		}
		elseif (strpos($page, '/en/'))
		{
			$page = str_replace('/en/', "/$lang/", $page);	
		}
		else
		{
			$page .= $lang.'/';
		}

		return $page;
	}

}