<?php
class Calendar {
	
	public function shortDate ($date, $locale = 'al') {
		list($date, $time) = explode(' ', $date);
		list($year, $month, $day) = explode('-', $date);
		
		if ($locale == 'al') {
			$date = $day . '/' . $month . '/' . $year;
		} else {
			$date = $month . '/' . $day . '/' . $year;
		}
		if ($time) {
			$date .= " $time";
		}
		
		return $date;
	}
	
	public function longDate ($date) {
		list($date, $time) = explode(' ', $date);
		list($year, $month, $day) = explode('-', $date);
		
		switch ($month) {
			case '01':
				$month = 'Janar';
				break;
			case '02':
				$month = 'Shkurt';
				break;
			case '03':
				$month = 'Mars';
				break;
			case '04':
				$month = 'Prill';
				break;
			case '05':
				$month = 'Maj';
				break;
			case '06':
				$month = 'Qershor';
				break;
			case '07':
				$month = 'Korrik';
				break;
			case '08':
				$month = 'Gusht';
				break;
			case '09':
				$month = 'Shtator';
				break;
			case '10':
				$month = 'Tetor';
				break;
			case '11':
				$month = 'Nentor';
				break;
			case '12':
				$month = 'Dhjetor';
				break;
		}
		
		$date = (int) $day . ' ' . $month . ' ' . $year;
		if ($time) {
			$date .= " $time";
		}
		
		return $date;
	}
	
	public function shortDateMysql ($date) {
		list($date, $time) = explode(' ', $date);
		list($day, $month, $year) = explode('/', $date);
		
		$date = $year . '-' . $month . '-' . $day;
		if ($time) {
			$date .= " $time";
		}
		
		return $date;
	}
	
	public function longDateMysql ($date) {
		list($day, $month, $year) = explode(' ', $date);
		
		switch ($month) {
			case 'Janar':
				$month = '01';
				break;
			case 'Shkurt':
				$month = '02';
				break;
			case 'Mars':
				$month = '03';
				break;
			case 'Prill':
				$month = '04';
				break;
			case 'Maj':
				$month = '05';
				break;
			case 'Qershor':
				$month = '06';
				break;
			case 'Korrik':
				$month = '07';
				break;
			case 'Gusht':
				$month = '08';
				break;
			case 'Shtator':
				$month = '09';
				break;
			case 'Tetor':
				$month = '10';
				break;
			case 'Nentor':
				$month = '11';
				break;
			case 'Dhjetor':
				$month = '12';
				break;
		}
		
		$date = $year . '-' . $month . '-' . $day;
		
		return $date;
	}
	
}